/* ***********************************************************************
   *                                                                     *
   * latrdefs.h                                                          *
   * Christian Zurhorst, BID R&D, 29 Jul. 1998                           *
   *                                                                     *
   * trace memory trigger definitions                                    *
   *                                                                     *
   ***********************************************************************

*/

#ifndef __LATRDEFS_H
#define __LATRDEFS_H


/*----------------------------------------------------------------
 * here start the performance option property defines 
 *----------------------------------------------------------------*/

/* trigger sequencer properties                                   */
/* although the following types are defined by different enums
   they should be enumerated contiguously in order to match the 
   enumeration in /minibios/../include/perf_ctl.h!                */

/* generic trigger sequencer properties */

#define B_TRIGSEQGENPROP_SIZE	 1

CLI typedef enum {
    B_TRIGSEQGEN_CTRC_PREL    /*@cprel       */
} b_trigseqgenproptype;


/* integer based trigger sequencer transient properties */

#define B_TRIGSEQTRANPROP_SIZE	 2

CLI typedef enum {
    B_TRIGSEQ_STATE,          /* @state     */
    B_TRIGSEQ_NEXTSTATE       /* @nextstate */
} b_trigseqtranproptype;


/* string based trigger sequencer transient properties */

#define B_TRIGSEQCONDPROP_SIZE	 8

/* this define is NOT to be changed and reflects the offset the properties
   for the sequencer conditions are increased (a Robert Siegmund hack) */
#define B_TRIGSEQ_CONDITION_OFFSET   4

CLI typedef enum {
    B_TRIGSEQ_XCOND,          /* @x         */
    B_TRIGSEQ_TRIGCOND,       /* @trig      */
    B_TRIGSEQ_SQCOND,         /* @sq        */
    B_TRIGSEQ_CE,             /* @ce        */
    B_TRIGSEQ_CLOAD           /* @cload     */
} b_trigseqtrancondproptype;

/* needed for special purposes (heartbeatmode used preload b and decrb) */
#define B_TRIGSEQ_DECRB    7
#define B_TRIGSEQ_PRELOADB 8


#endif
